﻿////////////////////////////////////////////////////////////////////////////
// Résumé : Renvoie un itinéraire enregistré sur la carte
// Syntaxe :
// [ <Résultat> = ] CarteRecupereItineraire (<Identifiant> est chaîne)
//
// Paramètres :
//	Identifiant (chaîne) : Identifiant de l'itinéraire renvoyé par CarteAjouteItinéraire
// Valeur de retour :
// 	objet (DirectionRenderer) : Objet Javascript représentant l'itinéraire ou Null en cas d'erreur
//
CarteRecupereItineraire = function(id) {
	var tabItineraire = CarteRecupereItineraires();
	for(i = 0; i < tabItineraire.length; i++) {
		if (tabItineraire[i].m_nID == id) {
			return tabItineraire[i];
		}
	}
	return null;
}

////////////////////////////////////////////////////////////////////////////
// Résumé : Conversion JSON
// Syntaxe :
// [ <Résultat> = ] VersJSON (<Objet> est objet)
//
// Paramètres :
//	Objet : objet Javascript à sérialiser
// Valeur de retour :
// 	chaîne ANSI : Représentation JSON de l'objet
//
VersJSON = function(o) {
    var cache = [];
    var js = "";
    if (cache.indexOf != undefined) {
        js = JSON.stringify(o, function(key, value) {
            if (typeof value === 'object' && value !== null) {
                if (cache.indexOf(value) !== -1) {
                    return;
       	        }
       	        cache.push(value);
            }
        return value;
        });
    } else {
        js = JSON.stringify(o);
    }
    cache = null;
    return js;
}